/**
 * Determines if the application is running in development mode
 * @returns {boolean} True if in development mode
 */
function isDevelopment() {
  // Check NODE_ENV or if we're in a development environment
  // In Electron renderer, we can also check if DevTools are available
  // or use a global flag set by the main process
  if (typeof process !== 'undefined' && process.env) {
    return process.env.NODE_ENV !== 'production';
  }
  // If process.env is not available, assume development
  // (packaged apps typically have process.env available)
  return true;
}

/**
 * Conditional logger that only logs in development mode
 */
const logger = {
  log: (...args) => {
    if (isDevelopment()) {
      console.log(...args);
    }
  },
  warn: (...args) => {
    if (isDevelopment()) {
      console.warn(...args);
    }
  },
  error: (...args) => {
    if (isDevelopment()) {
      console.error(...args);
    }
  },
  info: (...args) => {
    if (isDevelopment()) {
      console.info(...args);
    }
  },
  debug: (...args) => {
    if (isDevelopment()) {
      console.debug(...args);
    }
  }
};

// Export for use in modules
if (typeof module !== 'undefined' && module.exports) {
  module.exports = logger;
}

// Also make available globally for inline scripts
if (typeof window !== 'undefined') {
  window.logger = logger;
}

